{if $email}
<h4><div class="alert alert-success"> 
<i class="far fa-envelope fa-lg"></i> {$_lang.emailenviado}
</div>
</h4>
{/if}

{include file="$template/includes/tablelist.tpl" tableName="NotasFiscais"}
<div class="table-container clearfix">
    <table id="tableNotasFiscais" class="table table-list">
        <thead>
            <tr>
                <th>{$_lang.fatura}</th>
                <th>{$_lang.nfs}</th>
                <th>{$_lang.total}</th>
                <th>{$_lang.status}</th>
                <th>{$_lang.opcoes}</th>
            </tr>
        </thead>
        <tbody>
            {foreach $notas as $nota}
                <tr align="center">
                    <td><strong>{$nota.fatura}</strong></td>
                    <td>{$nota.idnfs}</td>
                    <td>R$ {$nota.total}</td>
                    <td><span class="label status status-{$nota.label}">{$nota.status}</span></td>
                    <td>
					{if $nota.btn}
						<a target="_blank" href="{$nota.pdf}" data-toggle="tooltip" data-placement="bottom" title="" class="btn btn-success btn-md " role="button" aria-pressed="true" data-original-title="{$_lang.visualizar}"><i class="fas fa-file-pdf fa-lg"></i></a> 
						<a target="_blank" href="{$nota.xml}" data-toggle="tooltip" data-placement="bottom" title="" class="btn btn-warning btn-md " role="button" aria-pressed="true" data-original-title="{$_lang.xml}"><i class="fas fa-code fa-lg"></i></a>
						<a onclick = "if (! confirm('Deseja enviar NFS-e {$nota.idnfs} da fatura #{$nota.fatura} por email?')) { return false; }" href="modules/addons/notafacil/lib/views/reenviar.php?id={$nota.fatura}&token={$nota.hash}" data-toggle="tooltip" data-placement="bottom" title="" class="btn btn-info btn-md " role="button" aria-pressed="true" data-original-title="{$_lang.email}"><i class="far fa-envelope fa-lg"></i></a>
					{/if}
					</td>		               						
				</tr>
            {/foreach}
        </tbody>
    </table>
</div>
