<?php

use WHMCS\Database\Capsule;

global $CONFIG;

if ($paymentmodule=="iugu" && $status=="Unpaid"){ // verifica se a fatura é iugu e se não foi paga.
	
	$iugu = Capsule::table('iugu')->where('invoice', $invoiceid)->orderBy('id', 'desc')->first(); 	
	
	if ($iugu->secure_url){
		include ROOTDIR."/modules/gateways/iugu/gerarpdf.php";		
	}
	else{
		include ROOTDIR . '/templates/'.$CONFIG['Template'].'/invoicepdf_nativo.tpl'; // se não possuir PIX gera PDF padrão.		
	}	
  
}
elseif ($paymentmodule=="pixjuno" && $status=="Unpaid"){ // verifica se a fatura é juno pix e se não foi paga.
	
	$pixJuno = Capsule::table('pix_juno')->where('invoice', $invoiceid)->orderBy('id', 'desc')->first(); 	
	
	if ($pixJuno->imageInBase64){
		include ROOTDIR."/modules/gateways/pixjuno/gerarpdf.php";		
	}
	else{
		include ROOTDIR . '/templates/'.$CONFIG['Template'].'/invoicepdf_nativo.tpl'; // se não possuir PIX gera PDF padrão.		
	}	
  
}
elseif ($paymentmodule=="boletofacil" && $status=="Unpaid"){ // verifica se a fatura é juno boleto e se não foi paga.

	$boletoJuno = Capsule::table('faturas_boletofacil')->where('fatura', $invoiceid)->orderBy('id', 'desc')->first();
		
	$consultaLink=simplexml_load_string($boletoJuno->xml);
	
	if ($consultaLink->data->charges->charge->link){
		include ROOTDIR."/modules/gateways/boletofacil/gerarpdf.php"; //faz o carregamento do Juno Boleto (PDF)	
	}
	else{
		include ROOTDIR . '/templates/'.$CONFIG['Template'].'/invoicepdf_nativo.tpl'; // se não for juno boleto gera o PDF padrão.		
	}
}
else{
	include ROOTDIR . '/templates/'.$CONFIG['Template'].'/invoicepdf_nativo.tpl'; // se não for juno boleto gera o PDF padrão.
}
?>